% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGWAS.R
\name{BGWAS}
\alias{BGWAS}
\title{Performs BGWAS analysis as in the BGWAS manuscript (Williams, J., Xu, S. and Ferreira, M.A., 2023. BGWAS: Bayesian variable selection in linear mixed models with nonlocal priors for genome-wide association studies. BMC Bioinformatics, 24(1), pp.1-20.).}
\usage{
BGWAS(
  Y,
  SNPs,
  FDR_Nominal = 0.05,
  kinship = diag(nrow(SNPs)),
  tau = "IG",
  maxiterations = 4000,
  runs_til_stop = 400
)
}
\arguments{
\item{Y}{The observed numeric phenotypes}

\item{SNPs}{The SNP matrix, where each column represents a single SNP encoded as the numeric coding 0, 1, 2. This is entered as a matrix object.}

\item{FDR_Nominal}{The nominal false discovery rate for which SNPs are selected from in the screening step. Defaulted at 0.05.}

\item{kinship}{The observed kinship matrix, has to be a square positive semidefinite matrix. Defaulted as the identity matrix. The function used
to create the kinship matrix used in the BICOSS paper is A.mat() from package rrBLUP.}

\item{tau}{This specifies the prior or the fixed value for the nonlocal prior on the SNP effects. To specify the Inverse Gamma prior set tau = "IG". To specify fixed values of tau set tau = 0.022. Fixed values explored in the BBGWAS manuscript were 0.022 and 0.348.}

\item{maxiterations}{The maximum iterations the genetic algorithm in the model selection step iterates for.
Defaulted at 400 which is the value used in the BICOSS paper simulation studies.}

\item{runs_til_stop}{The number of iterations at the same best model before the genetic algorithm in the model selection step converges.
Defaulted at 40 which is the value used in the BICOSS paper simulation studies.}
}
\value{
A named list that includes the output from the screening step and the output from the model selection step. The model proposed by the BGWAS method is the output of the model selection step.
}
\description{
Performs BGWAS analysis as in the BGWAS manuscript (Williams, J., Xu, S. and Ferreira, M.A., 2023. BGWAS: Bayesian variable selection in linear mixed models with nonlocal priors for genome-wide association studies. BMC Bioinformatics, 24(1), pp.1-20.).
}
\examples{
library(GWAS.BAYES)
BGWAS(Y = Y, SNPs = SNPs, kinship = kinship,
    FDR_Nominal = 0.05, tau = "IG",
    maxiterations = 400,runs_til_stop = 40)
}
