% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{filter_RNA_seq}
\alias{filter_RNA_seq}
\title{Filtering of low counts}
\usage{
filter_RNA_seq(
  data_expr,
  min_count = 5,
  method = c("at least one", "mean", "all")
)
}
\arguments{
\item{data_expr}{matrix or data.frame or SummarizedExperiment, table of
expression values (either microarray or RNA-seq), with genes as column and
samples as row.}

\item{min_count}{integer, minimal number of count to be considered in
method.}

\item{method}{string, name of the method for filtering. Must be one of "at
least one", "mean", or " all"}
}
\value{
A data.frame of filtered genes
}
\description{
Keeping genes with at least one sample with count above min_count in RNA-seq
data.
}
\details{
Low counts in RNA-seq can bring noise to gene co-expression module
building, so filtering them help to improve quality.
}
\examples{
df <- matrix(abs(rnorm(15*45)), 15) * 3
colnames(df) <- paste0("gene_", seq_len(ncol(df)))
rownames(df) <- paste0("sample_", seq_len(nrow(df)))
df_filtered <- filter_RNA_seq(df)

}
