% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{get_sub_clusters}
\alias{get_sub_clusters}
\title{Detect sub clusters}
\usage{
get_sub_clusters(network, seq_k = seq_len(15), fit_plot = TRUE, ...)
}
\arguments{
\item{network}{matrix or data.frame, strength of gene co-expression (edge
values).}

\item{seq_k}{vector, sequence of k number of cluster to test}

\item{fit_plot}{boolean, does the plot with silhouette coefficient depending
on the k tested should be plotted.}

\item{...}{any other parameter compatible with the
\code{\link[cluster]{pam}} function.}
}
\value{
data.frame, a two cols table with the gene id in the first one, and
the cluster number assignation in the second one.
}
\description{
Use a partitioning around medoid (PAM, or k-medoid) clustering method to
detect clusters into a provided module using the strength matrix of the
network
}
\examples{
df <- kuehne_expr[1:24, 1:350]
net <- build_net(df, n_threads = 1)
mods <- detect_modules(df, net$network)
net_mod_1 <- net$network[mods$modules$`1`, mods$modules$`1`]
get_sub_clusters(net_mod_1)

}
