% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_Similarity.R
\name{goDistance}
\alias{goDistance}
\title{Calculate similarity of GO terms}
\usage{
goDistance(
  geneset_ids,
  method = "Wang",
  ontology = "BP",
  species = "org.Hs.eg.db"
)
}
\arguments{
\item{geneset_ids}{\code{list}, a \code{list} of GO identifiers to score}

\item{method}{character, the method to calculate the GO distance.
Possible options are "Resnik", "Lin", "Rel",
"Jiang",  "Wang".}

\item{ontology}{character, the ontology to use. Possible options are "BP",
"MF" and "CC".}

\item{species}{character, the species of your data. Indicated as
org.XX.eg.db package from Bioconductor.}
}
\value{
A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} with the pairwise GO distance of each
geneset pair.
}
\description{
Calculate the pairwise similarity of GO terms
}
\examples{


## Mock example showing how the data should look like
go_ids <- c("GO:0002503", "GO:0045087", "GO:0019886",
            "GO:0002250", "GO:0001916", "GO:0019885")

similarity <- goDistance(go_ids)

## Example using the data available in the package
data(macrophage_topGO_example_small, package = "GeDi")
go_ids <- macrophage_topGO_example_small$Genesets
\dontrun{
similarity <- goDistance(go_ids)
}
}
