% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkBuilder.R
\name{polishNetwork}
\alias{polishNetwork}
\title{generate an object of grahpNEL to represent the regulation network}
\usage{
polishNetwork(
  cifNetwork,
  nodeData,
  nodesDefaultSize = 48,
  nodecolor = colorRampPalette(c("green", "yellow", "red"))(5),
  nodeBg = "white",
  nodeBorderColor = list(gene = "darkgreen", miRNA = "darkblue"),
  edgeWeight = NA,
  edgelwd = 0.5,
  ...
)
}
\arguments{
\item{cifNetwork}{dataframe used to draw network graph. column names of 
cifNetwork must contain 'from', 'to', 'logFC' and 'miRNA'}

\item{nodeData}{The node data. If it is not provide, node data will be 
retrieved from cifNetwork for the 'to' nodes.}

\item{nodesDefaultSize}{nodes default size}

\item{nodecolor}{a character vector of color set. 
The node color will be mapped to color set by log fold change.
Or the column names for the colors.}

\item{nodeBg}{background of node}

\item{nodeBorderColor}{a list of broder node color set. 
nodeBorderColor's element must be gene and miRNA}

\item{edgeWeight}{the weight of edge. It can be a column name of cifNetwork.}

\item{edgelwd}{the default width of edge. If edgeWeight is set, the edgelwd 
will be mapped to the edgeWeight.}

\item{...}{any parameters can be passed to \link[graph:settings]{graph.par}}
}
\value{
An object of graphNEL class of the network
}
\description{
generate an object of grahpNEL to represent the regulation network. 
Each node will has three attributes: size, borderColor and fill. 
The size will be mapped to the length of its edges. The node fill color will 
be mapped to logFC.
}
\examples{
data("ce.miRNA.map")
data("example.data")
data("ce.interactionmap")
data("ce.IDsMap")
sifNetwork<-buildNetwork(example.data$ce.bind, ce.interactionmap, level=2)
cifNetwork<-filterNetwork(rootgene=ce.IDsMap["DAF-16"], sifNetwork=sifNetwork, 
  exprsData=uniqueExprsData(example.data$ce.exprData, "Max", condenseName='logFC'),
  mergeBy="symbols",
  miRNAlist=as.character(ce.miRNA.map[ , 1]), tolerance=1)
gR<-polishNetwork(cifNetwork)
##	browseNetwork(gR)
}
\keyword{network}
