## Copyright (C) 2021 Robersy Sanchez <https://genomaths.com/>
## Author: Robersy Sanchez This file is part of the R package
## 'GenomAutomorphism'.  'GenomAutomorphism' is a free
## software: you can redistribute it and/or modify it under the
## terms of the GNU General Public License as published by the Free
## Software Foundation, either version 3 of the License, or (at
## your option) any later version.  This program is distributed in
## the hope that it will be useful, but WITHOUT ANY WARRANTY;
## without even the implied warranty of MERCHANTABILITY or FITNESS
## FOR A PARTICULAR PURPOSE. See the GNU General Public License for
## more details.  You should have received a copy of the GNU
## General Public License along with this program; if not, see
## <http://www.gnu.org/licenses/>.

#' Multiple Sequence Alignment (MSA) of Primate Somatic Cytochrome C
#'
#' This is a \code{\link[Biostrings]{DNAMultipleAlignment}} carrying a MSA of
#' [Primate Somatic Cytochrome C](https://bit.ly/3kdEAzs) to be used in the
#' examples provided for the package functions. The original file can be
#' downloaded from GitHub at: <https://bit.ly/3kdEAzs>
#' @author Robersy Sanchez <https://genomaths.com>
#' @seealso  [brca1_aln], [brca1_aln2], [covid_aln], and [covid_aln].
#' @usage 
#' data("cyc_aln", package = "GenomAutomorphism")
#' @format [DNAMultipleAlignment] class object.
#' @examples
#' data("cyc_aln", package = "GenomAutomorphism")
#' cyc_aln
#' 
"cyc_aln"
