% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-autoplot.R
\name{qcProteinSignal}
\alias{qcProteinSignal}
\title{Generate Protein QC signal boxplot figure}
\usage{
qcProteinSignal(object, neg.names = NULL)
}
\arguments{
\item{object}{name of the object class to subset
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{neg.names}{names of IgGs, if NULL IgGs will be detected automatically}
}
\value{
figure function
}
\description{
For use with protein data ONLY.
}
\examples{
proteinData <- readRDS(file= system.file("extdata","DSP_Proteogenomics_Example_Data", 
"proteinData.rds", package = "GeomxTools"))

igg.names <- iggNames(proteinData)

qcFig <- qcProteinSignal(object = proteinData, neg.names = igg.names)

qcFig()

}
