% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-qc.R
\name{setSegmentQCFlags}
\alias{setSegmentQCFlags}
\title{Add segment QC flags to protocol data}
\usage{
setSegmentQCFlags(object, qcCutoffs = DEFAULTS)
}
\arguments{
\item{object}{name of the object class to perform QC on
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{qcCutoffs}{list of cutoffs and thresholds to use for QC}
}
\value{
\code{NanoStringGeoMxSet} object with \code{QCFlags} data frame 
            appended to \code{protocolData}
}
\description{
Add segment QC flags to protocol data
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
setSegmentQCFlags(demoData[,1:10], 
                  qcCutoffs=list(minSegmentReads=1000, 
                                 percentAligned=80, 
                                 percentSaturation=50,
                                 minNegativeCount=10, 
                                 maxNTCCount=60,
                                 minNuclei=16000, 
                                 minArea=20))

}
