% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxQuery.R, R/gtoxSendQuery.R, R/query_funcs.R
\name{gtoxQuery}
\alias{gtoxQuery}
\alias{gtoxSendQuery}
\alias{Query functions}
\title{Wrappers for sending queries and fetching results}
\usage{
gtoxQuery(query, db = getOption("TCPL_DB"),
  drvr = getOption("TCPL_DRVR"))

gtoxSendQuery(query, db = getOption("TCPL_DB"),
  drvr = getOption("TCPL_DRVR"))
}
\arguments{
\item{query}{Character of length 1, the query string}

\item{db}{Character of length 1, the name of the gtox database}

\item{drvr}{Character of length 1, which database driver to use}
}
\value{
None
}
\description{
These functions send a query to the given database, and are the access point
for all gtox functions that query or update the gtox database.
}
\details{
Currently, the gtox package only supports the "MariaDB" and "SQLite" database
drivers.

\code{gtoxQuery} returns a data.table object with the query results.
\code{gtoxSendQuery} sends a query, but does not fetch any results, and 
returns 'TRUE' or the error message given by the database.
}
\examples{

## Perform query
gtoxSendQuery(paste0("SELECT * FROM assay_source"))


## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

gtoxQuery("SELECT 'Hello World';")
gtoxQuery("SELECT * FROM assay;")
 
## Reset configuration
options(conf_store)

}
