% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Module_annotation.R
\name{GSEAGO_Builder}
\alias{GSEAGO_Builder}
\title{GO enrichment for module names}
\usage{
GSEAGO_Builder(
  Auto_WGCNA_OUTPUT,
  species = "Homo sapiens",
  no_cores = 4,
  ontology = "BP",
  GO_conditional = FALSE,
  colname_correct = TRUE
)
}
\arguments{
\item{Auto_WGCNA_OUTPUT}{output from Auto_WGCNA function.}

\item{species}{either 'Homo sapiens' (default) or 'Mus musculus'.}

\item{no_cores}{Number of cores to use. Default = 4.}

\item{ontology}{string either 'BP'(Biological Process; default), 
'CC'(Cellular Component),
or 'MF' (Molecular Function).}

\item{GO_conditional}{A logical indicating whether the calculation 
should condition on the GO structure. 
will not be carried out. If TRUE,}

\item{colname_correct}{a logical value. If TRUE (default), "." in gene 
names will be replaced
with "-". This corrects a name change that is induced by R when creating a 
data.frame. If FALSE,
no changes will be made.}
}
\value{
Lists with gene ontology 
enrichment analysis, performed using GOstats,
for each module.
}
\description{
GO enrichment for module names
}
\note{
gene names must be official gene symbol
}
\examples{

GMIC_Builder_dir<-system.file("extdata", "GMIC_Builder.Rdata", 
                              package = "GmicR", mustWork = TRUE)
load(GMIC_Builder_dir)
GMIC_Builder$GSEAGO_Builder_Output<-NULL
Test_GMIC_Builder<-GSEAGO_Builder(GMIC_Builder, no_cores = 1)
summary(Test_GMIC_Builder$GSEAGO_Builder_Output)
}
