% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.R
\name{makeProbeCalls}
\alias{makeProbeCalls}
\title{Making Probe-level Calls}
\usage{
makeProbeCalls(pds, padj_cutoff = 0.05, one_hit_filter = TRUE)
}
\arguments{
\item{pds}{HERONProbeDataSet with the "padj" assay}

\item{padj_cutoff}{cutoff to use}

\item{one_hit_filter}{filter out one-hit probes?}
}
\value{
HERONProbeDataSet with the "calls" assay added
}
\description{
\code{makeProbeCalls} returns call information on a HERONProbeDataSet
using the "padj" assay
}
\examples{
data(heffron2021_wuhan)
pval_seq_res <- calcCombPValues(heffron2021_wuhan)
pval_probe_res <- convertSequenceDSToProbeDS(pval_seq_res)
calls_res <- makeProbeCalls(pval_probe_res)
}
