\name{HMMcopy-package}
\alias{HMMcopy-package}
\alias{HMMcopy}
\docType{package}
\title{
Bias-free copy number estimation and robust CNA detection in tumour samples from
WGS HTS data
}
\description{
HMMcopy is a package for making bias-free copy number estimation by correcting
for GC-content and mappability bias in HTS readcounts.  It also contains
an implementation of the Hidden Markov Model to robustly segment a copy number
profile into non-overlapping segments predicted to be of the same copy number
state, and attributes a biological copy number aberration events to the
segments.
}
\details{
HMMcopy takes as input WIG format files generated by fast C++ tools distributed
as part of the \emph{HMMcopy Suite}, namely readcount, GC-content and
mappability values for non-overlapping fixed width \dQuote{bins} across the
reference genome of interest.  It then uses a filtering and LOESS model to
correct the GC-content and mappability biases observed in the readcounts
(Benjamini and Speed, 2012), and uses the corrected readcounts as a proxy of
copy number.  The resultant copy number profile is then segmented with a six
state Hidden Markov Model, with a handful of quick visualization functions for
quick viewing.


\tabular{ll}{
Package: \tab HMMcopy\cr
Type: \tab Package\cr
Version: \tab 0.1.0\cr
Date: \tab 2011-09-06\cr
License: \tab GPL-3\cr
}

\code{example("HMMcopy-package")} for quick tour of functionality and
visualization

\code{vignette("HMMcopy")} for detailed example

}
\author{
Daniel Lai, Gavin Ha, Sohrab Shah

Maintainer: Daniel Lai <jujubix@cs.ubc.ca> and Gavin Ha <gha@bccrc.ca>
}

\references{
Yuval Benjamini and Terence P Speed. Summarizing and correcting the gc content bias
in high-throughput sequencing. Nucleic Acids Res, \bold{40(10)}:e72, May 2012.
}

\keyword{IO}
\keyword{manip}

\examples{

# Read WIG file input
rfile <- system.file("extdata", "tumour.wig", package = "HMMcopy")
gfile <- system.file("extdata", "gc.wig", package = "HMMcopy")
mfile <- system.file("extdata", "map.wig", package = "HMMcopy")
uncorrected_reads <- wigsToRangedData(rfile, gfile, mfile)

# Correct reads into copy number
corrected_copy <- correctReadcount(uncorrected_reads)

# Segment copy number profile
segmented_copy <- HMMsegment(corrected_copy)

# Visualize one at a time
par(ask = TRUE)
plotBias(corrected_copy)
plotCorrection(corrected_copy)
plotSegments(corrected_copy, segmented_copy)

}
