% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_get_matrix}
\alias{Brick_get_matrix}
\title{Return a matrix subset.}
\usage{
Brick_get_matrix(
    Brick,
    chr1,
    chr2,
    x_coords,
    y_coords,
    resolution,
    force = FALSE,
    FUN = NULL
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr1}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the rows of the matrix}

\item{chr2}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the columns of the matrix}

\item{x_coords}{\strong{Required}.
A one-dimensional numeric vector specifying the rows to subset.}

\item{y_coords}{\strong{Required}.
A one-dimensional numeric vector specifying the columns to subset.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{force}{\strong{Optional}. Default FALSE
If true, will force the retrieval operation when matrix contains loaded
data until a certain distance.}

\item{FUN}{\strong{Optional}.
If provided a data transformation with FUN will be applied before the matrix
is returned.}
}
\value{
Returns a matrix of dimension x_coords length by y_coords length.
This may differ based on the operations with FUN.
}
\description{
\code{Brick_get_matrix} will fetch a matrix subset between row values
ranging from min(x_coords) to max(x_coords) and column values ranging from
min(x_coords) to max(x_coords)
}
\examples{
Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "get_matrix_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_matrix(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", matrix_file = Matrix_file, delim = " ", 
remove_prior = TRUE, resolution = 100000)

Brick_get_matrix(Brick = My_BrickContainer, chr1 = "chr2L", chr2 = "chr2L",
x_coords = c(1:10), y_coords = c(1:10), resolution = 100000)

}
\seealso{
\code{\link{Brick_get_matrix_within_coords}} to get matrix by using
matrix genomic coordinates, \code{\link{Brick_get_values_by_distance}} to
get values separated at a certain distance,
\code{\link{Brick_fetch_row_vector}} to getvalues in a certain row/col and
subset them, \code{\link{Brick_get_vector_values}} to get values using
matrix coordinates.
}
