% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_features_chr.R
\name{construct_features_chr}
\alias{construct_features_chr}
\title{construct_features_chr}
\usage{
construct_features_chr(
  chrom,
  gen = "Hsapiens",
  gen_ver = "hg19",
  sig = "GATC",
  bin_type = "Bins-uniform",
  binsize = 5000,
  wg_file = NULL,
  feature_type = "RE-based"
)
}
\arguments{
\item{chrom}{select a chromosome.}

\item{gen}{name of the species: e.g., default \code{'Hsapiens'}.}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}.}

\item{sig}{restriction enzyme cut pattern (or a vector of patterns; e.g.,
'GATC' or c('GATC','GANTC')).}

\item{bin_type}{'Bins-uniform' if uniformly binned by binsize in
bp, or 'Bins-RE-sites' if binned by number of
restriction enzyme fragments.}

\item{binsize}{binsize in bp if bin_type='Bins-uniform' (or number of
RE fragment cut sites if bin_type='Bins-RE-sites'), defaults to 5000.}

\item{wg_file}{path to the bigWig file containing mappability values across
the genome of interest.}

\item{feature_type}{'RE-based' if features are to be computed based on
restriction enzyme fragments. 'RE-agnostic' ignores restriction enzyme cutsite 
information and computes features gc and map based on binwide averages. bin_type
has to be 'Bins-uniform' if \code{feature_type='RE-agnostic'}.}
}
\value{
a features 'bintolen' file that contains GC, mappability and length
features.
}
\description{
This function lists all restriction enzyme cutsites of a given genome and
genome version with genomic features outlined in Carty et al. (2017) for
a single chromosome.
https://www.nature.com/articles/ncomms15454; GC content, mappability,
and effective length
}
\examples{
df<-construct_features_chr(chrom='chr22',
gen='Hsapiens', gen_ver='hg19',sig=c('GATC','GANTC'),bin_type='Bins-uniform',
binsize=100000,wg_file=NULL)
}
