% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabularParsers.R
\name{parseTabular}
\alias{parseTabular}
\title{Parser for tabular data}
\usage{
parseTabular(path, sep = '\t')
}
\arguments{
\item{path}{A path to a tabular file.}

\item{sep}{The separator of the tabular file. Default to tabulation.}
}
\value{
An InteractionSet object.
}
\description{
Read the file, produce an \code{InteractionSet} object.
}
\details{
Accepts a tabular file with \code{chromosome}, \code{position 1},
\code{position 2}, and multiple replicate columns listing interaction counts.
Null interactions do not have to be listed. Values must be separated by
tabulations. The header must be
\code{chromosome position 1 position 2 x.y x.y x.y ...} with \code{x}
replaced by condition names and \code{y} replaced by replicate names.
}
\examples{
path <- system.file("extdata", "hicsample_21.tsv", package = "HiCParser")
object <- parseTabular(path, sep = "\t")

}
