% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisqtest-methods.R
\name{AIC-INSPEcT-method}
\alias{AIC-INSPEcT-method}
\alias{AIC,INSPEcT_model-method}
\alias{AIC,INSPEcT-method}
\title{Akaike information criterion calculated for the models evaluated by INSPEcT}
\usage{
\S4method{AIC}{INSPEcT_model}(object, ..., k = 2)

\S4method{AIC}{INSPEcT}(object, ..., k = 2)
}
\arguments{
\item{object}{An object of class INSPEcT or INSPEcT_model}

\item{...}{Additional arguments for the generic}

\item{k}{Additional parameter for the generic}
}
\value{
A matrix of AIC values
}
\description{
This method is used to retrieve AIC values for all models tested for all genes.
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
AIC(nascentInspObj10)
}
