% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifyExpressionsFromTrCounts-functions.R
\name{quantifyExpressionsFromTrCounts}
\alias{quantifyExpressionsFromTrCounts}
\title{Evaluates introns and exons RPKMs, per gene, from counts data.}
\usage{
quantifyExpressionsFromTrCounts(
  allcounts,
  experimentalDesign,
  exonsWidths,
  intronsWidths,
  libsize = NULL,
  DESeq2 = TRUE,
  varSamplingCondition = NULL
)
}
\arguments{
\item{allcounts}{A named list containing "exonsCounts" and "intronsCounts".}

\item{experimentalDesign}{A numerical which reports the desing of the experiment in terms of time points and replicates.
Time points must be ordered according to the sequence of files submitted for the analysis, these labels characterize
different files as replicates of a given condition.}

\item{exonsWidths}{A numeric containing the exons widths.}

\item{intronsWidths}{A numeric containing the intorns widths.}

\item{libsize}{A numeric containing the library size.}

\item{DESeq2}{A logical, if TRUE the RPKMs variances are evaluated through the package DESeq2, if FALSE plgem is used.}

\item{varSamplingCondition}{A character reporting which experimental condition should be used to sample the variance if DESeq2 = FALSE. By default, the first element of "experimentalDesign" with replicates.}
}
\value{
A list containing RPKMs and associated variances for exons and introns.
}
\description{
Evaluates introns and exons RPKMs, per gene, from counts data.
}
\examples{
data('allcounts', package='INSPEcT')
data('featureWidths', package='INSPEcT')
data('libsizes', package='INSPEcT')

nascentCounts<-allcounts$nascent
matureCounts<-allcounts$mature

expDes<-rep(c(0,1/6,1/3,1/2,1,1.5,2,4,8,12,16),3)

nasExp_DESeq2<-quantifyExpressionsFromTrCounts(libsize=nascentLS
                                              ,exonsWidths=exWdths
                                              ,intronsWidths=intWdths
                                              ,allcounts=nascentCounts
                                              ,experimentalDesign=expDes)

matExp_DESeq2<-quantifyExpressionsFromTrCounts(libsize=totalLS
                                              ,exonsWidths=exWdths
                                              ,intronsWidths=intWdths
                                              ,allcounts=matureCounts
                                              ,experimentalDesign=expDes)

nasExp_plgem<-quantifyExpressionsFromTrCounts(libsize=nascentLS
                                             ,exonsWidths=exWdths
                                             ,intronsWidths=intWdths
                                             ,allcounts=nascentCounts
                                             ,DESeq2=FALSE
                                             ,experimentalDesign=expDes)

matExp_plgem<-quantifyExpressionsFromTrCounts(libsize=totalLS
                                             ,exonsWidths=exWdths
                                             ,intronsWidths=intWdths
                                             ,allcounts=matureCounts
                                             ,DESeq2=FALSE
                                             ,experimentalDesign=expDes)
}
