% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNGAfy.R
\name{CoNGAfy}
\alias{CoNGAfy}
\title{Reduce a Single-Cell Object to Representative Cells}
\usage{
CoNGAfy(
  input.data,
  method = "dist",
  features = NULL,
  assay = "RNA",
  meta.carry = c("CTaa", "CTgene")
)
}
\arguments{
\item{input.data}{A single-cell dataset in Seurat or SingleCellExperiment format.}

\item{method}{Character. Specifies the method to reduce the dataset:
\itemize{
\item "mean" - Computes the mean expression of selected features across cells in each clonotype.
\item "dist" - Uses PCA reduction to identify the cell with the minimal Euclidean distance within each clonotype group.
}}

\item{features}{Character vector. Selected genes for the reduction. If \code{NULL} (default), all genes are used.}

\item{assay}{Character. The name of the assay or assays to include in the output. Defaults to the active assay.}

\item{meta.carry}{Character vector. Metadata variables to carry over from the input single-cell object to the output.}
}
\value{
A reduced single-cell object where each clonotype is represented by a single cell.
}
\description{
This function generates a single-cell object with a reduced representation
of RNA expression by clone. The approach is inspired by the method introduced
in \href{https://pubmed.ncbi.nlm.nih.gov/34426704/}{CoNGA}. Users can
generate either a mean representation of features by clone or identify a
representative cell using count-based minimal Euclidean distance.
Please read and cite the original work by the authors of CoNGA.
}
\examples{
#' # Get Data
ibex_example <- get(data("ibex_example"))

ibex.clones <- CoNGAfy(ibex_example, 
                       method = "dist")

ibex.clones <- CoNGAfy(ibex_example, 
                       method = "mean")

}
