% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/23.run_limmaAnalysis.R
\name{run_limmaAnalysis}
\alias{run_limmaAnalysis}
\title{use limma to analyze the PDUI}
\usage{
run_limmaAnalysis(
  UTR3eset,
  design,
  contrast.matrix,
  coef = 1,
  robust = FALSE,
  ...
)
}
\arguments{
\item{UTR3eset}{An object of \linkS4class{UTR3eSet}, output of \code{\link[=get_UTR3eSet]{get_UTR3eSet()}}}

\item{design}{A design matrix of the experiment, with rows corresponding to
arrays and columns to coefficients to be estimated. Defaults to the unit
vector meaning that the arrays are treated as replicates. see
\code{\link[stats:model.matrix]{stats::model.matrix()}}}

\item{contrast.matrix}{A numeric matrix with rows corresponding to coefficients
in fit and columns containing contrasts. May be a vector if there is only
one contrast. see \code{\link[limma:makeContrasts]{limma::makeContrasts()}}}

\item{coef}{An integer(1) vector specifying which coefficient or a character(1)
vector specifying which contrast of the linear model is to test. see more
\code{\link[limma:toptable]{limma::topTable()}}. Default, 1.}

\item{robust}{A logical(1) vector,indicating whether the estimation of the
empirical Bayes prior parameters be robustified against outlier sample
variances?}

\item{...}{other arguments which are passed to \code{\link[limma:lmFit]{limma::lmFit()}}}
}
\value{
fit results of eBayes by limma. It is an object of class
\link[limma:marraylm]{limma::MArrayLM} containing everything found by fit. see
\code{\link[limma:ebayes]{limma::eBayes()}}
}
\description{
use limma to analyze the PDUI
}
\seealso{
\code{\link[=run_singleSampleAnalysis]{run_singleSampleAnalysis()}}, \code{\link[=run_singleGroupAnalysis]{run_singleGroupAnalysis()}}, \code{\link[=run_fisherExactTest]{run_fisherExactTest()}}
}
\author{
Jianhong Ou
}
\keyword{internal}
