% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_mapping_info.R
\name{edge_mapping_info}
\alias{edge_mapping_info}
\title{Prepare edges for mapping}
\usage{
edge_mapping_info(expanded_edges, data_added = FALSE,
  significance_markup = FALSE, tidy_edge = TRUE)
}
\arguments{
\item{expanded_edges}{The data frame object generated via the function 
expand_KEGG_edges() OR has been modified by the function add_edge_data()}

\item{data_added}{A logical indicator; must be set to TRUE if user data has
been added (i.e. edges modified by function add_edge_data())}

\item{significance_markup}{A logical indicator; if set to TRUE will color 
edges based on direction and significance of correlation (as determined by 
user-data-analysis)}

\item{tidy_edge}{A logical indicator; must be set to FALSE for expanded edges}
}
\value{
A data.frame object for edges that will be passed on to the function 
get_graph_object
}
\description{
Modify the mapping information for desired look when graphed in
 Cytoscape
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <- expand_KEGG_mappings(p53_KGML)

#Default; no data added to edges:

p53_edges <- expand_KEGG_edges(p53_KGML, p53_KEGG_mappings)
p53_edge_mapping_info <- edge_mapping_info(p53_edges) 

#If data is added to edges as additional attribute[s]:

p53_HA1E_data <- overlap_info(p53_KGML, p53_KEGG_mappings, 
                               "HA1E", data_type = "100_bing")

p53_edges_HA1E_data_MAPPED <- add_edge_data(p53_edges, p53_KEGG_mappings, 
                                            p53_HA1E_data, 
                                            data_column_no = c(3, 10,12),
                                            only_mapped = TRUE)
                                               
p53_edge_mapping_HA1E <- edge_mapping_info(p53_edges_HA1E_data_MAPPED, 
                                                      data_added = TRUE)
                                                      
}
