% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_trn.R
\name{rf_trn}
\alias{rf_trn}
\title{rf_trn allows assessing the final DEGs through a machine learning step by using Random Forest in a cross validation process.}
\usage{
rf_trn(data, labels, vars_selected, numFold = 10)
}
\arguments{
\item{data}{The data parameter is an expression matrix or data.frame that contains the genes in the columns and the samples in the rows.}

\item{labels}{A vector or factor that contains the labels for each of the samples in the data object.}

\item{vars_selected}{The genes selected to classify by using them. It can be the final DEGs extracted with the function \code{\link{DEGsExtraction}} or a custom vector of genes. Furthermore, the ranking achieved by \code{\link{featureSelection}} function can be used as input of this parameter.}

\item{numFold}{The number of folds to carry out in the cross validation process.}
}
\value{
A list that contains four objects. The confusion matrix for each fold, the accuracy, the sensitibity and the specificity for each fold and each genes.
}
\description{
rf_trn allows assessing the final DEGs through a machine learning step by using Random Forest in a cross validation process. This function applies a cross validation of n folds with representation of all classes in each fold. The 80\% of the data are used for training and the 20\% for test.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))

rf_trn(t(DEGsMatrix)[,1:10],labels,rownames(DEGsMatrix)[1:10],2)
}
