% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{longitudinal.tree.plot}
\alias{longitudinal.tree.plot}
\title{longitudinal.tree.plot}
\usage{
longitudinal.tree.plot(
  inference,
  rem_unseen_leafs = TRUE,
  show_plot = TRUE,
  filename = "lg_output.xml",
  labels_show = "mutations",
  clone_labels = NULL,
  show_prev = TRUE,
  label.cex = 1,
  size = 500,
  size2 = NULL,
  tk_plot = FALSE,
  tp_lines = TRUE,
  tp_mark = TRUE,
  tp_mark_alpha = 0.5,
  legend = TRUE,
  legend_position = "topright",
  label_offset = 4,
  legend_cex = 0.8
)
}
\arguments{
\item{inference}{Results of the inference by LACE.}

\item{rem_unseen_leafs}{If TRUE (default) remove all the leafs that have never been observed (prevalence = 0 in each time point)}

\item{show_plot}{If TRUE (default) output the longitudinal tree to the current graphical device.}

\item{filename}{Specify the name of the file where to save the longitudinal tree. Dot or graphml formats are supported and are chosen based on the extenction of the filename (.dot or .xml).}

\item{labels_show}{Specify which type of label should be placed on the tree; options are, 
"mutations": parental edges are labeled with the acquired mutation between the two nodes (genotypes); 
"clones": nodes (genotypes) are labeled with their last acquired mutation; 
"both": either nodes and edges are labeled as specified above; 
"none": no labels will show on the longitudinal tree.}

\item{clone_labels}{Character vector that specifies the name of the nodes (genotypes). If it is NULL (default), nodes will be labeled as specified by "label" parameter.}

\item{show_prev}{If TRUE (default) add to clones label the correspongind prevalance.}

\item{label.cex}{Specify the size of the labels.}

\item{size}{Specify size of the nodes. The final area is proportional with the node prevalence.}

\item{size2}{Specify the size of the second dimension of the nodes. If NULL (default), it is set equal to "size".}

\item{tk_plot}{If TRUE, uses tkplot function from igraph library to plot an interactive tree. Default is FALSE.}

\item{tp_lines}{If TRUE (defaul) the function draws lines between timepoints.}

\item{tp_mark}{If TRUE (defaul) the function draws different colored area under the nodes in different time points.}

\item{tp_mark_alpha}{Specify the alpha value of the area drawed when tp_mark = TRUE.}

\item{legend}{If TRUE (default) a legend will be displayed on the plot.}

\item{legend_position}{Specify the legend position.}

\item{label_offset}{Move the mutation labels horizontally (default = 4)}

\item{legend_cex}{Specify size of the legend text.}
}
\value{
An igraph object g with the longitudinal tree inferred by LACE.
}
\description{
Plot a longitudinal tree inferred by LACE.
}
\examples{
data(inference)
clone_labels = c("ARPC2","PRAME","HNRNPC","COL1A2","RPL5","CCT8")
longitudinal.tree.plot(inference = inference,
                       labels = "clones",
                       clone_labels = clone_labels,
                       legend_position = "topleft")

}
