% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadRegionDB.R
\name{getRegionFile}
\alias{getRegionFile}
\title{Grab the filename for a a single region set from a database specified by filename.}
\usage{
getRegionFile(dbLocation, filenames, collections = NULL)
}
\arguments{
\item{dbLocation}{folder of regionDB}

\item{filenames}{Filename(s) of a particular region set to grab.}

\item{collections}{(optional) subset of collections to list}
}
\value{
A filename the specified file in the regionDB.
}
\description{
Like getRegionSet but returns a filename instead of a GRanges object. Given a local
filename, returns a complete absolulte path so you can read that file in.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionDB = loadRegionDB(dbLocation=dbPath)
data("sample_universe", package="LOLA")
data("sample_input", package="LOLA")

getRegionSet(regionDB, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionSet(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionFile(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")


res = runLOLA(userSets, userUniverse, regionDB, cores=1)
locResult = res[2,]
extractEnrichmentOverlaps(locResult, userSets, regionDB)
writeCombinedEnrichment(locResult, "temp_outfolder")

userSetsRedefined =	redefineUserSets(userSets, userUniverse)
resRedefined = runLOLA(userSetsRedefined, userUniverse, regionDB, cores=1)

g = plotTopLOLAEnrichments(resRedefined)

}
