% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Limma_permutating.R
\name{Limma_permutating}
\alias{Limma_permutating}
\title{Perform Permutation-Based Linear Modeling with Covariates using Limma}
\usage{
Limma_permutating(x, group.name, meta.info, formula.str)
}
\arguments{
\item{x}{A data matrices where rows represent
features (e.g., genes, proteins) and columns represent samples. The list
should contain at least two matrices for pairwise group comparison.}

\item{group.name}{A character string indicating the name of the group
variable in \code{meta.info} to be used in the analysis.}

\item{meta.info}{A data frame containing the metadata for the samples.
This includes sample grouping and any covariates to be included in the model.}

\item{formula.str}{A string specifying the formula to be used in model
fitting. It should follow the standard R formula syntax
(e.g., \code{~ covariate1 + covariate2}).}
}
\value{
A list containing the following elements:
\item{d}{A vector of the test statistics (log-fold changes or F-statistics)
for each feature.}
\item{s}{A vector of the standard deviations for each feature, adjusted by
the empirical Bayes procedure.}
}
\description{
This function performs linear modeling using the Limma package with
permutation of the covariates to evaluate the test statistics under random
assignments. It handles two-group comparisons and multi-group settings.
}
\details{
This function combines the data matrices from different groups and permutes
the covariates from \code{meta.info}before fitting a linear model using Limma.
Permutation helps assess how the covariates behave under random conditions,
providing a null distribution of the test statistics. For two-group
comparisons, the function computes contrasts between the two groups and
applies empirical Bayes moderation. For multi-group analysis with a single
covariate, pairwise contrasts are computed, and the moderated F-statistic is
calculated for each feature.
}
\seealso{
\code{\link[limma]{lmFit}}, \code{\link[limma]{eBayes}},
\code{\link[limma]{topTable}},
\code{\link[limma]{makeContrasts}}
}
