% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.HClust.R
\name{Linnorm.HClust}
\alias{Linnorm.HClust}
\title{Linnorm-hierarchical clustering analysis.}
\usage{
Linnorm.HClust(
  datamatrix,
  RowSamples = FALSE,
  MZP = 0,
  DataImputation = TRUE,
  input = "Raw",
  method_hclust = "ward.D",
  method_dist = "pearson",
  Group = NULL,
  num_Clust = 0,
  Color = "Auto",
  ClustRect = TRUE,
  RectColor = "red",
  fontsize = 0.5,
  linethickness = 0.5,
  plot.title = "Hierarchical clustering",
  ...
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM, TPM or Linnorm transformed data are supported. Undefined values such as NA are not supported.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to TRUE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{MZP}{Double >=0, <= 1. Minimum non-Zero Portion Threshold for this function. Genes not satisfying this threshold will be removed from HVG anlaysis. For exmaple, if set to 0.3, genes without at least 30 percent of the samples being non-zero will be removed. Defaults to 0.}

\item{DataImputation}{Logical. Perform data imputation on the dataset after transformation. Defaults to TRUE.}

\item{input}{Character. "Raw" or "Linnorm". In case you have already transformed your dataset with Linnorm, set input into "Linnorm" so that you can input the Linnorm transformed dataset into the "datamatrix" argument. Defaults to "Raw".}

\item{method_hclust}{Charcter. Method to be used in hierarchical clustering. (From hclust {fastcluster}: the agglomeration method to be used. This should be (an unambiguous abbreviation of) one of "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid".) Defaults to "ward.D".}

\item{method_dist}{Charcter. Method to be used in hierarchical clustering. (From Dist {amap}: the distance measure to be used. This must be one of "euclidean", "maximum", "manhattan", "canberra", "binary", "pearson", "correlation", "spearman" or "kendall". Any unambiguous substring can be given.) Defaults to "pearson".}

\item{Group}{Character vector with length equals to sample size. Each character in this vector corresponds to each of the columns (samples) in the datamatrix. If this is provided, sample names will be colored according to their group. Defaults to NULL.}

\item{num_Clust}{Integer >= 0. Number of clusters in hierarchical clustering. No cluster will be highlighted if this is set to 0. Defaults to 0.}

\item{Color}{Character vector. Color of the groups/clusters in the plot. This vector must be as long as num_Clust, or Group if it is provided. Defaults to "Auto".}

\item{ClustRect}{Logical. If num_Clust > 0, should a rectangle be used to highlight the clusters? Defaults to TRUE.}

\item{RectColor}{Character. If ClustRect is TRUE, this controls the color of the rectangle. Defaults to "red".}

\item{fontsize}{Numeric. Font size of the texts in the figure. Defualts to 0.5.}

\item{linethickness}{Numeric. Controls the thickness of the lines in the figure. Defaults to 0.5.}

\item{plot.title}{Character. Set the title of the plot. Defaults to "Hierarchical clustering".}

\item{...}{arguments that will be passed into Linnorm's transformation function.}
}
\value{
It returns a list with the following objects:
\itemize{
 \item{Results:}{ If num_Clust > 0, this outputs a named vector that contains the cluster assignment information of each sample. Else, this outputs a number 0.}
 \item{plot:}{ Plot of hierarchical clustering.}
 \item{Linnorm:}{ Linnorm transformed data matrix.}
}
}
\description{
This function first performs Linnorm transformation on the dataset. Then, it will perform hierarchical clustering analysis.
}
\details{
This function performs PCA clustering using Linnorm transformation.
}
\examples{
#Obtain example matrix:
data(Islam2011)
#Example:
HClust.results <- Linnorm.HClust(Islam2011, Group=c(rep("ESC",48), rep("EF",44), rep("NegCtrl",4)))
}
\keyword{CPM}
\keyword{Clustering}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Linnorm}
\keyword{Parametric}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{TPM}
\keyword{hierarchical}
\keyword{normalization}
\keyword{transformation}
