\name{html.report}
\alias{html.report}
\alias{html.report.arrayCGH}
\alias{html.report.default}
\title{Generate an HTML report of array normalization}
\description{
  Create an HTML file with various illustrations of array normalization,
  including plots before and after normalization, and statistics about
  flagged spots and clones
}

\usage{
  \method{html.report}{arrayCGH}(array.norm, array.nonorm=NULL, dir.out=".",
array.name=NULL, x="PosOrder", y=c("LogRatioNorm", "LogRatio"), chrLim=NULL,
ylim=NULL, zlim=NULL, clim=NULL, intensity=NULL, light=FALSE,
file.name="report", width=10, height=5, \ldots)

  \method{html.report}{default}(spot.data, clone.data=NULL,
  flag.data=NULL, quality.data=NULL, \ldots) 
}
\arguments{
  \item{array.norm}{an object of type \code{arrayCGH} after normalization step}
  \item{array.nonorm}{an optional object of type arrayCGH after a
    normalization step with no flags}
  \item{spot.data}{a data.frame containing spot-level informations
    (e.g. \code{arrayCGH\$arrayValues})}
  \item{clone.data}{a data.frame containing clone-level informations
    (e.g. \code{arrayCGH\$cloneValues})}
  \item{flag.data}{a data.frame containing information about flags, with
    fields \code{char}, \code{label}, \code{arg}, \code{count} as
    generated by function \code{\link{flag.summary}}}
  \item{quality.data}{a data.frame containing information about quality
    scores with fields \code{name}, \code{label}, \code{score} as
    generated by function \code{\link{qscore.summary}}}
  \item{dir.out}{absolute path of a directory where the file is
    generated (defaults to the current directory)}
  \item{array.name}{name or identifier of the array}
  \item{x}{a variable name from \code{arrayCGH\$cloneValues} giving the order position
    of the clones along the genome (defaults to 'PosOrder')}
  \item{y}{a vector of one or two variable names to be passed to \code{\link{report.plot}}}
  \item{chrLim}{an optional variable name from \code{arrayCGH\$cloneValues}
    giving the limits of each chromosome}
  \item{ylim}{a numeric vector of length 2 to be passed to
    \code{\link{report.plot}}: y axis range of the genomic profile display}
  \item{clim}{a numeric vector of length 2 to be passed to
    \code{\link{report.plot}}: color range of the genomic profile}
  \item{zlim}{a numeric vector of length 2 to be passed to
    \code{\link{report.plot}}: color range for array image display}
  \item{intensity}{an optional list with names c("M.var", "A.var",
    "pred.var", "span"). The first 3 items specify existing variable names
    from \code{arrayCGH\$arrayValues} that will be used to draw a
    MA-plot. The last item is the value of the loess 'span'}
  \item{light}{boolean value: if (light), only the core of the html file
    is generated; if (!light), a complete html file is generated}
  \item{file.name}{file name of the generated report (defaults to
    "report")}
  \item{width}{plot width, in inches}
  \item{height}{plot height, in inches}
  \item{...}{further arguments to be passed to \code{\link{report.plot}}}
}

\value{none}
\details{
  This function creates an HTML report file showing
  - the array image and the genome representation before normalization
  (if \code{array.nonorm} is provided) and after normalization, and
  optionally a MA-plot
  - a table with information about the number of flagged spots for each
  flag, and the number of remaining spots after normalization
  - a table with information about various quality criteria for the
  array
}

\author{Pierre Neuvial, \email{manor@curie.fr}.}

\note{People interested in tools for array-CGH analysis can
  visit our web-page: \url{http://bioinfo.curie.fr}.}

\keyword{IO}
\seealso{\code{\link{flag.summary}}, \code{\link{report.plot}}}
