% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/060.cluster.analysis.R
\name{cluster.analysis}
\alias{cluster.analysis}
\title{Cluster analysis with normalised backbone measurements and the complete dataset}
\usage{
cluster.analysis(paths, bkb.v, yvar = "Legend", control.wells, plots = TRUE)
}
\arguments{
\item{paths}{a vector of characters of paths to store intput, intermediary results, outputs...}

\item{bkb.v}{a vector of the names of the backbone markers (MUST match to the names in the FCS file).}

\item{yvar}{the name of the well-specific marker in the FCS files (e.g., "Legend").}

\item{control.wells}{the well label of the control wells, including the autofluorescence and the isotype controls (format: plate_well, e.g., P1_A01)}

\item{plots}{logical; if TRUE (default), produce an UMAP embedding plot from the normalised backbone markers and the imputed infinity markers to visualise the structure of the biological clusters.}
}
\value{
Metadata for cells with group labels from the cluster analysis
}
\description{
This function has been designed to perform cluster analysis for the normalised backbone measurements and the complete dataset which includes the normalised backbone measurements and the imputed well-specific markers.
}
\details{
Updating the metadata for cells in the fcs_metadata_df.rds file, adding the information of the biological clusters from the clean and complete dataset, and visualising the result with the scatter plots in the output directory.
}
\author{
Hsiao-Chi Liao
}
