% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecPCAPlot}
\alias{mbecPCAPlot}
\title{PCA plotting function}
\usage{
mbecPCAPlot(plot.df, metric.df, model.vars, pca.axes, label = NULL)
}
\arguments{
\item{plot.df}{Data.frame containing principal component data.}

\item{metric.df}{Data.frame containing covariate data.}

\item{model.vars}{two covariates of interest to select by first variable
selects panels and second one determines coloring.}

\item{pca.axes}{NMumerical two-piece vector that selects PCs to plot.}

\item{label}{Name of the plot displayed as legend title.}
}
\value{
ggplot2 object
}
\description{
Takes data.frame from mbecPCA and produces a ggplot2 object.
}
\examples{
# This will return a paneled plot that shows results for the variance
# assessment.
data(dummy.mbec)
pca.df <- mbecPCA(input.obj=dummy.mbec,
model.vars=c('group','batch'), pca.axes=c(1,2), return.data=TRUE)
plot.pca <- mbecPCAPlot(plot.df=pca.df[[1]], metric.df=pca.df[[2]],
model.vars=c('group','batch'), pca.axes=c(1,2))
}
\keyword{RLE}
\keyword{expression}
\keyword{log}
\keyword{relative}
