% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_corrections.R
\name{mbecPLSDA}
\alias{mbecPLSDA}
\title{Partial Least Squares Discriminant Analysis}
\usage{
mbecPLSDA(input.obj, model.vars, type = c("clr", "otu", "tss"))
}
\arguments{
\item{input.obj}{phyloseq object or numeric matrix (correct orientation is
handeled internally)}

\item{model.vars}{Vector of covariate names. First element relates to batch.}

\item{type}{Which abundance matrix to use, one of 'otu, tss, clr'. DEFAULT is
'clr'.}
}
\value{
A matrix of batch-effect corrected counts
}
\description{
This function estimates latent dimensions from the explanatory matrix
X. The latent dimensions are maximally associated with the outcome
matrix Y. It is a built-in function of PLSDA_batch and has been
adjusted to work in the MBECS-package. To that end, the function
mixOmics::explained_variance was replaced with a computation based on
vegan::cca since this is already used in the MBECS package.
Additionally, the matrix deflation function was replaced with own code. The
near zero-variance correction function is taken from the caret -package. The
credit for algorithm and implementation goes to
'https://github.com/EvaYiwenWang/PLSDAbatch' and the associated publication
that is referenced in the documentation and vignette.
}
\keyword{PLSDA}
\keyword{batch}
\keyword{correction}
