% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_corrections.R
\name{mbecRUV3}
\alias{mbecRUV3}
\title{Remove Unwanted Variation 3 (RUV-3)}
\usage{
mbecRUV3(
  input.obj,
  model.vars,
  type = c("clr", "otu", "tss"),
  nc.features = NULL
)
}
\arguments{
\item{input.obj}{phyloseq object or numeric matrix (correct orientation is
handeled internally)}

\item{model.vars}{Vector of covariate names. First element relates to batch.}

\item{type}{Which abundance matrix to use, one of 'otu, tss, clr'. DEFAULT is
'clr'.}

\item{nc.features}{(OPTIONAL) A vector of features names to be used as
negative controls in RUV-3. If not supplied, the algorithm will use an 'lm'
to find pseudo-negative controls}
}
\value{
A matrix of batch-effect corrected counts
}
\description{
This algorithm requires negative control-features, i.e., OTUs that are known
to be unaffected by the batch effect, as well as technical replicates. The
algorithm will check for the existence of a replicate column in the covariate
data. If the column is not present, the execution stops and a warning message
will be displayed.
}
\details{
The input for this function is supposed to be an MbecData object that
contains total sum-scaled and cumulative log-ratio transformed abundance
matrices. Output will be a matrix of corrected abundances.
}
\keyword{Assessment}
\keyword{Batch-Effect}
\keyword{Correction}
