% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HclustGenesHiCor.R
\name{HclustGenesHiCor}
\alias{HclustGenesHiCor}
\title{Find the most highly correlated genes using hierarchical clustering}
\usage{
HclustGenesHiCor(gem, seed, cuts)
}
\arguments{
\item{gem}{Gene expression matrix with genes as rows and samples as columns}

\item{seed}{Seed of highly correlating samples}

\item{cuts}{Number of groups to cut dendogram into}
}
\value{
Numeric vector of most highly correlated genes
}
\description{
Upon finding an initial bicluster with \code{FindSeed()} not all the genes
in the chosen geneset will be highly correlated to the bicluster. 
\code{HclustGenesHiCor()} uses the output of \code{FindSeed()} and 
hierarchical clustering to only select the genes that are most highly correlated
to the bicluster. This is achieved by cutting the dendogram produced
from the clustering into a set number of groups and then only selecting the
groups that are most highly correlated to the bicluster
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- which(row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

random.seed <- sample(seq(length = dim(CCLE.mito)[2]),10)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 100)


CorScoreCalc(CCLE.mito, random.seed)
CorScoreCalc(CCLE.mito, CCLE.seed)

CCLE.hicor.genes <- as.numeric(HclustGenesHiCor(CCLE.mito,
                                                CCLE.seed,
                                                cuts = 8))

CorScoreCalc(CCLE.mito[CCLE.hicor.genes,], CCLE.seed)
}
