% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDiffVarAnalysis.R
\name{runDiffVarAnalysis}
\alias{runDiffVarAnalysis}
\title{Run differential variance analysis}
\usage{
runDiffVarAnalysis(
  set,
  model,
  coefficient = NULL,
  resultSet = TRUE,
  betas = TRUE,
  warnings = TRUE,
  ...
)
}
\arguments{
\item{set}{Matrix, \code{GenomicRatioSet}, \code{SummarizedExperiment} or 
\code{ExpressionSet}.}

\item{model}{Model matrix or formula to get model matrix from \code{set}.}

\item{coefficient}{Numeric with the coefficients used to make the groups. If NULL, all
possible groups will be computed.}

\item{resultSet}{Should results be encapsulated in a \code{resultSet}? (Default: TRUE)}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}

\item{warnings}{Should warnings be displayed? (Default:TRUE)}

\item{...}{Further arguments passed to \code{varFit}.}
}
\value{
\code{MArrayLM} or \code{resultSet} with the result of the differential
variance analysis.
}
\description{
Run differential variance analysis. This analysis can only be run with categorical 
variables. This function relies on \code{varFit} from missMethyl package.
}
\examples{
if (require(minfiData)){
 mvalues <- getM(MsetEx)[1:100, ]
 model <- model.matrix(~ Sample_Group, data = pData(MsetEx)) 
 res <- runDiffVarAnalysis(mvalues, model)
 res
}
}
