% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runRegionAnalysis.R
\name{runRegionAnalysis}
\alias{runRegionAnalysis}
\title{Run different DMR detection methods}
\usage{
runRegionAnalysis(
  set,
  model,
  methods = c("blockFinder", "bumphunter", "DMRcate"),
  coefficient = 2,
  bumphunter_params = NULL,
  blockFinder_params = NULL,
  dmrcate_params = NULL,
  verbose = FALSE,
  resultSet = TRUE
)
}
\arguments{
\item{set}{\code{GenomicRatioSet}, \code{eSet} derived object or 
\code{SummarizedExperiment}}

\item{model}{Model matrix representing a linear model.}

\item{methods}{Character vector with the names of the methods used to estimate 
the regions. Valid names are: "blockFinder", "bumphunter" and "DMRcate".}

\item{coefficient}{Numeric with the index of the model matrix used to perform
the analysis.}

\item{bumphunter_params}{List with other parameter passed to \code{runBumphunter} 
function.}

\item{blockFinder_params}{List with other parameter passed to \code{runBlockFinder} 
function.}

\item{dmrcate_params}{List with other parameter passed to \code{runDMRcate} 
function.}

\item{verbose}{Logical value. Should the function be verbose? (Default: FALSE)}

\item{resultSet}{Should results be encapsulated in a \code{resultSet}? (Default: TRUE)}
}
\value{
List or \code{resultSet} with the result of the DMR detection methods.
}
\description{
Run different DMR detection methods
}
\details{
This function has been deprecated and will be defunct in the new version.
}
\examples{
if (require(minfiData)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
 model <- model.matrix(~Sample_Group, data = pData(MsetEx))
 res <- runRegionAnalysis(set, model) 
 res
}
}
\seealso{
\code{\link[minfi]{bumphunter}}, \code{\link[minfi]{blockFinder}}, 
\code{\link[DMRcate]{dmrcate}}
}
