% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMDiff2_data.R
\docType{data}
\name{MMD}
\alias{MMD}
\title{DBAmmd Object for Cfp1 example}
\usage{
data('MMD')
}
\description{
DBAmmd Object for Cfp1 example
}
\examples{
# data was created as follows:
\dontrun{
library('MMDiff2')
library('MMDiffBamSubset')
# create metaData:
ExperimentData <- list(genome='BSgenome.Mmusculus.UCSC.mm9',
                      dataDir=system.file("extdata", package="MMDiffBamSubset"),
                      sampleSheet="Cfp1.csv")
MetaData <- list('ExpData' = ExperimentData)
MMD <- DBAmmd(MetaData)
data("Cfp1-Peaks")

MMD <- setRegions(MMD,Peaks)
MMD <- getPeakReads(MMD,pairedEnd=FALSE, run.parallel=FALSE)

MMD <- DBAmmd(MetaData)
MMD <- setRegions(MMD,Peaks)
MMD <- getPeakReads(MMD,pairedEnd=FALSE, run.parallel=FALSE)
MMD <- estimateFragmentCenters(MMD, shift=NULL, draw.on=FALSE)
MMD <- compHists(MMD, bin.length=20)
MMD <- compDists(MMD, dist.method = "MMD", run.parallel = FALSE)
group1 <- Samples(MMD)$Condition==1
names(group1) <- Samples(MMD)$SampleID
group2 <- Samples(MMD)$Condition==2
names(group2) <-  Samples(MMD)$SampleID
con <- list(group1=group1,
           group2=group2,
           name1='WT-Resc',
           name2='KO')

MMD <- compPvals(MMD, contrasts=list(con))
}
}
\keyword{data}

