% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moma.r
\docType{class}
\name{Moma-class}
\alias{Moma-class}
\alias{Moma}
\title{MOMA Object}
\description{
Main class encapsulating the input data and logic of the MOMA algorithm
}
\section{Fields}{

\describe{
\item{\code{viper}}{matrix of inferred activity score inferred by viper}

\item{\code{mut}}{binary mutation matrix 1 for presence of mutation, 0 for not, NA 
if not determined}

\item{\code{cnv}}{matrix of cnv values. Can be binary or a range.}

\item{\code{fusions}}{binary matrix of fusion events if appliable}

\item{\code{pathways}}{list of pathways/connections to consider as extra evidence 
in the analysis}

\item{\code{gene.blacklist}}{character vector of genes to not include because of 
high mutation frequency}

\item{\code{output.folder}}{character vector of location to save files if desired}

\item{\code{gene.loc.mapping}}{data frame of gene names, entrez ids and cytoband locations}

\item{\code{nes}}{field for saving Normalized Enrichment Matrices from the associate events step}

\item{\code{interactions}}{field for saving the MR-interactions list}

\item{\code{clustering.results}}{results from clustering are saved here}

\item{\code{ranks}}{results field for ranking of MRs based on event association analysis}

\item{\code{hypotheses}}{results field for saving events that have enough occurences to be considered}

\item{\code{genomic.saturation}}{results field for genomic saturation analysis}

\item{\code{coverage.summaryStats}}{results field for genomic saturation analysis}

\item{\code{checkpoints}}{results field with the MRs determined to be the checkpoint for each cluster}

\item{\code{sample.clustering}}{field to save sample clustering vector. Numbers are 
cluster assignments, names are sample ids}
}}

\section{Methods}{

\describe{
\item{\code{Cluster(
  clus.eval = c("reliability", "silhouette"),
  use.parallel = FALSE,
  cores = 1
)}}{Cluster the samples after applying the MOMA weights to the VIPER scores}

\item{\code{makeInteractions(
  genomic.event.types = c("amp", "del", "mut", "fus"),
  cindy.only = FALSE
)}}{Make interaction web for significant MRs based on their associated events}

\item{\code{Rank(
  use.cindy = TRUE,
  genomic.event.types = c("amp", "del", "mut", "fus"),
  use.parallel = FALSE,
  cores = 1
)}}{Rank MRs based on DIGGIT scores and number of associated events}

\item{\code{runDIGGIT(fCNV = NULL, cnvthr = 0.5, min.events = 4, verbose = FALSE)}}{Run DIGGIT association function to get associations for driver genomic events}

\item{\code{saturationCalculation(
  clustering.solution = NULL,
  cov.fraction = 0.85,
  topN = 100,
  verbose = FALSE
)}}{Calculate the number of MRs it takes to represent the desired coverage fraction of events}
}}

