% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supertest&frequencyplot.R
\name{runSupertest}
\alias{runSupertest}
\title{Performs a Exact test - analysis of omics intersection}
\usage{
runSupertest(
  multiPathwayReportData,
  pvalueThr = 0.05,
  zscoreThr = 0.05,
  resampligThr = NULL,
  plot = c("circular", "landscape", "noplot"),
  sort.by = c("set", "size", "degree", "p-value"),
  excludeColumns = NULL,
  color.on = "#f6bb42",
  color.off = "#D3D3D3"
)
}
\arguments{
\item{multiPathwayReportData}{data.frame, the output of the
\code{\link{multiPathwayReport}} or \code{\link{multiPathwayModuleReport}}
functions.}

\item{pvalueThr}{numeric value. Overall pvalue cut-off to be used}

\item{zscoreThr}{numeric value. Covariates coefficient cut-off to be used.}

\item{resampligThr}{numeric value. Filters the modules according to the
number of success in the resampling procedure, takes only the modules above
this threshold.}

\item{plot}{character indicating the layout for plotting. It is one of
\code{circular}, \code{landscape} or \code{noplot}. By default,
plot='circular', if plot='noplot' no plot will be provided.}

\item{sort.by}{character indicating how to sort the
intersections in the plot. It is one of 'set' (by omics), 'size'
(by intersection size), 'degree' (by number of intersected omics),
and 'p-value'.}

\item{excludeColumns}{a vector of characters listing the columns of
\code{multiPathwayReportData} object to be excluded by the analysis.
In the case \code{multiPathwayReportData} derives from
\code{\link{multiPathwayModuleReport}}
you should set \code{excludeColumns = c('pathway','module')}.}

\item{color.on}{color that represent the active omics in the sector}

\item{color.off}{color that represent the omics mnot considered in the
sector}
}
\value{
a data.frame containing all the numeric information of the plot
included the pathways shared by different omics.
}
\description{
This function performs a exact test implementing a theorical framework using
the SuperExactTest package. It calculates the statistical distributions of
multi omics set intersections. It can be used with both a MultiOmicsModules
or MultiOmicsPathway class objects.
}
\details{
This function calculates intersection sizes between multiple set of
pathways or modules and performs statistical test of the intersections using
the total amout of analyzed pathways or modules as background. The super
exact test of this function was described in Wang et al 2015.
}
\examples{
df <- data.frame(
    pvalue = c(0.06, 0.04, 0.04, 0.03, 0.02),
    cnv = c(0.07, 0.03, 0.02, 0.04, 0.01),
    mut = c(0.08, 0.02, 0.01, 0.04, 0.04),
    row.names = c(
        "PathwayA", "PathwayB", "PathwayC",
        "PathwayD", "PathwayE"
    )
)

runSupertest(df, pvalueThr = 0.05, zscoreThr = 0.05)

}
\references{
Minghui Wang, Yongzhong Zhao, and Bin Zhang (2015).
Efficient Test and Visualization of Multi-Set Intersections.
Scientific Reports 5: 16923.
}
