% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsim_functions.R
\name{sparsim_simulation}
\alias{sparsim_simulation}
\title{Function to simulate a raw count table}
\usage{
sparsim_simulation(
  dataset_parameter,
  output_sim_param_matrices = FALSE,
  output_batch_matrix = FALSE,
  count_data_simulation_seed = NULL
)
}
\arguments{
\item{dataset_parameter}{list containing, the intensity, variability and lib sizes of each experimental condition. It is the return value of "estimate_parameter_from_data" or could be created by the users}

\item{output_sim_param_matrices}{boolean flag. If TRUE, the function will output two additional matrices, called abundance_matrix and variability_matrix, containing the gene intensities and gene variabilities used as simulation input. (Default: FALSE)}

\item{output_batch_matrix}{boolean flag. If TRUE, the function will output an additional matrix, called batch_factors_matrix, containing the multiplicative factors used in batch effect simulation. (Default: FALSE)}

\item{count_data_simulation_seed}{inherited from sparsim}
}
\value{
A list of 5 elements:

  - \code{count_matrix}: the simulated count matrix (genes on rows, samples on columns)

  - \code{gene_matrix}: the simulated gene expression levels (genes on rows, samples on columns)

  - \code{abundance_matrix}: the input gene intensity values provided as input (genes on rows, samples on columns), if \code{output_sim_param_matrices} = TRUE. NULL otherwise.

  - \code{variability_matrix}: the input gene variability values provided as input (genes on rows, samples on columns), if \code{output_sim_param_matrices} = TRUE. NULL otherwise.

  - \code{batch_factors_matrix}: the multiplicative factor used in batch generation (genes on rows, samples on columns), if \code{output_batch_matrix} = TRUE. NULL otherwise.
}
\description{
This function is a copy of the `SPARSIM_simulation` function from the
`SPARSim` package (v0.9.5), originally developed by Giacomo Baruzzo,
Ilaria Patuzzi, Barbara Di Camillo (2020). The original package is licensed
under the GPL-3 license.
}
