% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltNeiStt.R
\name{pltNeiStt}
\alias{pltNeiStt}
\title{Plot a heatmap of pathway and omic states of a protein and its
pathway neighbors}
\usage{
pltNeiStt(real_se, fltmat, fpth, protein = "")
}
\arguments{
\item{real_se}{A SummarizedExperiment object of PARADIGM CNA and RNA
states. It is the output fromm \code{ppRealInp()} and must
contain the omic states for the one defined in the
\code{protein} argument.}

\item{fltmat}{A matrix contains filterd IPL with rows as entity and
column as samples. This is the output from \code{fltByPerm()}.
Entity with NA value will be set to 0 and plotted as in
'normal' state.}

\item{fpth}{Name of a pathway file for PARADIGM.}

\item{protein}{Name of the protein to plot. It requires to have CN and RNA
state data, as well as pathway data from the input.
Default: ''}
}
\value{
A heatmap of pathway and omic states of a protein and its
pathway neighbors
}
\description{
Plot a heatmap of pathway and omic states of a protein and its
pathway neighbors
}
\examples{

fpth = system.file('extdata/Pth/tiny_pth.txt', package='MPAC')

freal = system.file('extdata/pltNeiStt/inp_real.rds', package='MPAC')
fflt  = system.file('extdata/pltNeiStt/fltmat.rds',   package='MPAC')

real_se = readRDS(freal)
fltmat = readRDS(fflt)
protein = 'CD86'

pltNeiStt(real_se, fltmat, fpth, protein)

}
