% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subNtw.R
\name{subNtw}
\alias{subNtw}
\title{Subset pathways by IPL results}
\usage{
subNtw(fltmat, fpth, fgmt, min_n_gmt_gns = 2, threads = 1)
}
\arguments{
\item{fltmat}{A matrix contains filterd IPL with rows
as 'entity' and column as samples. This is the output from
\code{fltByPerm()}. Entity with NA in all columns will be ignored.}

\item{fpth}{Name of a pathway file for PARADIGM.}

\item{fgmt}{A gene set GMT file. This will be the same file used for the
gene set over-representation calculation in the next step. It
is used here to ensure output sub-pathway contains a minimum
number of genes from to-be-used gene sets.}

\item{min_n_gmt_gns}{Minimum number of genes from the GMT file in the output
sub-pathway. Default: 2.}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
A list of igraph objects representing the largest sub-pathway
for each sample.
}
\description{
Subset pathways by IPL results
}
\examples{

fflt = system.file('extdata/fltByPerm/flt_real.rds', package='MPAC')
fltmat = readRDS(fflt)
fpth = system.file('extdata/Pth/tiny_pth.txt',       package='MPAC')
fgmt = system.file('extdata/ovrGMT/fake.gmt',        package='MPAC')

subNtw(fltmat, fpth, fgmt, min_n_gmt_gns=1)


}
