% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string2region.R
\name{string2region}
\alias{string2region}
\title{string2region}
\usage{
string2region(seq, mask = NULL, region = NULL, add = TRUE)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}

\item{mask}{\code{IRanges} object indicating masked sites [default: NULL]}

\item{region}{\code{IRanges} object indicating region to use for dist
calculation (by default all sites are used) [default: NULL]}

\item{add}{indicate if mask and region should be added to \code{metadata}
[default: TRUE]}
}
\value{
A \code{list} object with the following components:\cr
\code{DNAStringSet} or \code{AAStringSet}\cr
\code{regionUsed}\cr
}
\description{
This function subsets a \code{DNAStringSet} or an
\code{AAStringSet} by a \code{mask} and \code{region} given one or both
options as \code{IRanges}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
## create mask
mask1 <- IRanges::IRanges(start=c(11,41,71), end=c(20,50,80))
## use mask
hiv.region <- hiv |> cds2aa() |> string2region(mask=mask1)
#(hiv.region |> slot("metadata"))$regionUsed
hiv.region |> regionused()
## use region
region1 <- IRanges::IRanges(start=c(1,75), end=c(45,85))
hiv.region <- hiv |> cds2aa() |> string2region(region=region1)
#(hiv.region |> slot("metadata"))$regionUsed
hiv.region |> regionused()
## use mask and region
hiv.region <- hiv |> cds2aa() |> string2region(mask=mask1, region=region1)
#(hiv.region |> slot("metadata"))$regionUsed
hiv.region |> regionused()
}
\seealso{
\code{\link[MSA2dist]{dnastring2dist}}
}
\author{
Kristian K Ullrich
}
