% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{MSstatsLiP_Summarized}
\alias{MSstatsLiP_Summarized}
\title{MSstatsLiP_Summarized}
\format{
A list containing two lists of summarization information for LiP and TrP data.
}
\usage{
MSstatsLiP_Summarized
}
\description{
Example output of MSstatsLiP summarization function dataSummarizationLiP.
}
\details{
Example output of MSstatsLiP summarization function dataSummarizationLiP.
A list containing two lists named LiP and TrP containing summarization information
for LiP and TrP data. Each of LiP and TrP contain data named: FeatureLevelData,
ProteinLevelData, SummaryMethod, ModelQC, PredictBySurvival. The two main
data.tables (FeatureLevelData and ProteinLevelData are shown below):

\itemize{
\item FeatureLevelData : \itemize{
\item PROTEIN : Protein ID with modification site mapped in. Ex.
Protein_1002_S836
\item FULL_PEPTIDE (LiP Only) : Combined name of protein and peptide sequence
\item PEPTIDE : Full peptide with charge
\item TRANSITION: Charge
\item FEATURE : Combination of Protien, Peptide, and Transition Columns
\item LABEL :
\item GROUP : Condition (ex. Healthy, Cancer, Time0)
\item RUN : Unique ID for technical replicate of one TMT
mixture.
\item SUBJECT : Unique ID for biological subject.
\item FRACTION : Unique Fraction ID
\item originalRUN : Run name
\item censored :
\item INTENSITY : Original intensity value
\item ABUNDANCE : Log adjusted intensity value
\item newABUNDANCE : Normalized abundance column
}
\item ProteinLevelData : \itemize{
\item RUN : MS run ID
\item FULL_PEPTIDE (LiP Only) : Combined name of protein and peptide sequence
\item Protein : Protein ID with modification site mapped in. Ex.
Protein_1002_S836
\item LogIntensities: Protein-level summarized abundance
\item originalRUN : Labeling information (126, ... 131)
\item GROUP : Condition (ex. Healthy, Cancer, Time0)
\item SUBJECT : Unique ID for biological subject.
\item TotalGroupMeasurements : Unique ID for technical replicate of one TMT
mixture.
\item NumMeasuredFeature : Unique ID for TMT mixture.
\item MissingPercentage : Unique ID for TMT mixture.
\item more50missing : Unique ID for TMT mixture.
\item NumImputedFeature : Unique ID for TMT mixture.
}
}
}
\examples{
head(MSstatsLiP_Summarized$LiP$FeatureLevelData)
head(MSstatsLiP_Summarized$LiP$ProteinLevelData)

head(MSstatsLiP_Summarized$TrP$FeatureLevelData)
head(MSstatsLiP_Summarized$TrP$ProteinLevelData)

}
\keyword{datasets}
