% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC50_prediction.R
\name{bootstrapIC50}
\alias{bootstrapIC50}
\title{Bootstrap IC50 Estimates and Confidence Interval (ratio scale)}
\usage{
bootstrapIC50(
  dose,
  response,
  n_samples = 1000,
  alpha = 0.1,
  increasing = FALSE,
  target_response = 0.5,
  transform_x = TRUE
)
}
\arguments{
\item{dose}{Numeric vector of dose values.}

\item{response}{Numeric vector of response values (on log2 scale).}

\item{n_samples}{Number of bootstrap samples (default = 1000).}

\item{alpha}{Significance level for confidence interval (default = 0.10).}

\item{increasing}{Logical. Fit non-decreasing if TRUE.}

\item{target_response}{Numeric value for response level (default = 0.5).}

\item{transform_x}{Logical. If TRUE, applies log10(dose + 1) transformation. Default = TRUE.}
}
\value{
List with mean IC50, CI bounds, and transformed estimates.
}
\description{
Bootstrap IC50 Estimates and Confidence Interval (ratio scale)
}
