% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_MSstatsTMT.R
\docType{data}
\name{annotation.mine}
\alias{annotation.mine}
\title{Example of annotation file for raw.mine, which is the output of SpectroMine.}
\format{
A data frame with 72 rows and 7 variables.
}
\usage{
annotation.mine
}
\description{
Annotation of example data, raw.mine, in this package.
It should be prepared by users.
The variables are as follows:
}
\details{
\itemize{
  \item Run : MS run ID. It should be the same as R.FileName info
  in raw.mine
  \item Channel : Labeling information (TMT6_126, ..., TMT6_131).
  The channels should be consistent with the channel columns in raw.mine.
  \item Condition : Condition (ex. Healthy, Cancer, Time0). If the channal doesn't have sample, please add 'Empty' under Condition.
  \item Mixture : Mixture of samples labeled with different TMT reagents, which can be analyzed in
  a single mass spectrometry experiment.
  \item TechRepMixture : Technical replicate of one mixture. One mixture may have multiple technical replicates.
  For example, if 'TechRepMixture' = 1, 2 are the two technical replicates of one mixture, then they should match
  with same 'Mixture' value.
  \item Fraction : Fraction ID. One technical replicate of one mixture may be fractionated into multiple fractions to increase the analytical depth.
  Then one technical replicate of one mixture should correspond to multuple fractions.
  For example, if 'Fraction' = 1, 2, 3 are three fractions of the first technical replicate of one TMT mixture of biological subjects,
  then they should have same 'TechRepMixture'  and 'Mixture' value.
  \item BioReplicate : Unique ID for biological subject. If the channal doesn't have sample, please add 'Empty' under BioReplicate
}
}
\examples{
head(annotation.mine)

}
\keyword{datasets}
