% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_columns_class.R
\name{select_columns}
\alias{select_columns}
\title{Select columns}
\usage{
select_columns(expression = everything(), ...)
}
\arguments{
\item{expression}{(call) A valid rlang::expr for tidy evaluation via
eval_select. e.g.  \code{expression = all_of(c("foo","bar"))} will select
columns named "foo" and "bar" from the annotation data.frame.  . The
default is \code{everything()}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{select_columns} object with the following
\code{output} slots:
\tabular{ll}{
\code{updated} \tab (annotation_source) The updated annotations as an
\code{annotation_source} object. \cr
}
}
\description{
A wrapper around \code{\link[tidyselect:eval_select]{tidyselect::eval_select}}. Select
columns from an annotation table using tidy grammar. This imitates
\code{\link[dplyr:select]{dplyr::select()}}.
}
\details{
This object makes use of functionality from the following
packages:\itemize{ \item{\code{tidyselect}} \item{\code{rlang}}}
}
\section{Inheritance}{

A \code{select_columns} object inherits the following \code{struct} classes:
\cr\cr
\verb{[select_columns]} -> \verb{[model]} -> \verb{[struct_class]}
}

\examples{
M <- select_columns(
        expression = call("example"))

}
\references{
Henry L, Wickham H (2024). \emph{tidyselect: Select from a Set
of Strings}. doi:10.32614/CRAN.package.tidyselect
\url{https://doi.org/10.32614/CRAN.package.tidyselect}, R package version
1.2.1, \url{https://CRAN.R-project.org/package=tidyselect}.

Henry L, Wickham H (2025). \emph{rlang: Functions for Base
Types and Core R and 'Tidyverse' Features}.
doi:10.32614/CRAN.package.rlang
\url{https://doi.org/10.32614/CRAN.package.rlang}, R package version
1.1.6, \url{https://CRAN.R-project.org/package=rlang}.
}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}

\code{\link[tidyselect:eval_select]{tidyselect::eval_select()}}
}
