% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{partialCorrelation}
\alias{partialCorrelation}
\title{Calculate the partial correlation and p-values}
\usage{
partialCorrelation(x, method = "pearson", ...)
}
\arguments{
\item{x}{`matrix`, where columns are the features (metabolites) and the rows are 
samples, cell entries are intensity values}

\item{method}{`character`, either "pearson", "spearman"}

\item{...}{further arguments passed to `cor` from `base` or 
`cor2pcor` from `corpcor`}
}
\value{
`list` containing two matrices, 
the first matrix contains correlation coefficients and 
the second matrix contains the corresponding p-values
}
\description{
`partialCorrelation` infers an adjacency matrix of partial correlation 
values and associated p-values using using the `cor2pcor` function (from the
`corpcor` package). `partialCorrelation` calculates the p-values from the 
number of samples (`n`) and the number of controlling variables (`g`). 
The function will return a list containing the 
weighted adjacency matrix of the correlation values, together with the 
associated p-values.
}
\details{
The correlation coefficients \eqn{r_{ij|S}} are obtained from `cor2pcor`
(`corpcor` package).

The t-values are calculated via

\eqn{t_{ij|S} = r_{ij|S} \cdot \sqrt{\frac{n-2-g}{1-r_{ij|S}^2}} },
where $n$ are the number of samples and $g$ the number of controlling
variables (number of features - 2).

The p-values are calculated as follows
\eqn{p_{ij|S} = 2 \cdot pt(-abs(t_{ij|S}), df = n - 2 - g)}
}
\examples{
data("x_test", package = "MetNet")
x <- x_test[, 3:ncol(x_test)]
x <- as.matrix(x)
x <- t(x)
partialCorrelation(x, use = "pairwise", method = "pearson")

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
