% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterStats.R
\name{clusterStats}
\alias{clusterStats}
\title{Derive summary statistics for clusters}
\usage{
clusterStats(fcsFrame, clusterList, fcsNames)
}
\arguments{
\item{fcsFrame}{A flow Frame object returned from preprocessing function.
Must contain a parameter called "sample_id" that specify the origin of
each cell using integer IDs.}

\item{clusterList}{A list, each element should be a vector containing the IDs
of all cells that belong to a cluster.}

\item{fcsNames}{A vector of fcs file names. Each element corresponds to an
integer ID in the "sample_id" parameter in fcsFrame.}
}
\value{
Returns a data frame, rows correspond to each fcs file, columns
  correspond to MFI of markers or fractions.
}
\description{
A function that derives summary statistics for clusters.
}
\examples{
# Find fcs files
files=system.file("extdata","SDY420/ResultFiles/CyTOF_result",
                  package="MetaCyto")
files=list.files(files,pattern="fcs$",full.names=TRUE)
# Preprocess
fcs = preprocessing(fcsFiles=files,assay ="CyTOF",b=1/8)
# Search clusters
cluster_list=searchCluster(fcsFrame=fcs,
                           clusterLabel=c("CD3+|CD8+","CD3-|CD19+"))
# derive summary statistics
cluster_stats=clusterStats(fcsFrame=fcs,
                           clusterList=cluster_list$clusterList,
                           fcsNames=files)
}
