% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{MethylMix_Predict}
\alias{MethylMix_Predict}
\title{The MethylMix_Predict function}
\usage{
MethylMix_Predict(newBetaValuesMatrix, MethylMixResult)
}
\arguments{
\item{newBetaValuesMatrix}{Matrix with new observations for prediction, 
genes/cpg sites in rows, samples in columns. Although this new matrix can have
a different number of genes/cpg sites than the one provided as METcancer when
running MethylMix, naming of genes/cpg sites should be the same.}

\item{MethylMixResult}{Output object from MethylMix}
}
\value{
A matrix with predictions (indices of mixture component), driver genes in rows, new samples in columns
}
\description{
Given a new data set with methylation data, this function predicts the mixture
component for each new sample and driver gene. Predictions are based on posterior 
probabilities calculated with MethylMix'x fitted mixture model.
}
\examples{
# load the three data sets needed for MethylMix
data(METcancer)
data(METnormal)
data(GEcancer)

# run MethylMix on a small set of example data
MethylMixResults <- MethylMix(METcancer, GEcancer, METnormal)
# toy example new data, of same dimension of original METcancer data
newMETData <- matrix(runif(length(METcancer)), nrow = nrow(METcancer))
rownames(newMETData) <- rownames(METcancer)
colnames(newMETData) <- paste0("sample", 1:ncol(METcancer))
predictions <- MethylMix_Predict(newMETData, MethylMixResults)

}
