% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-TrioSet.R
\name{segment2}
\alias{segment2}
\alias{segment2,TrioSet-method}
\alias{segment2,matrix-method}
\alias{segment2,ff_matrix-method}
\alias{segment2,arrayORff_array-method}
\title{A wrapper for DNAcopy's segment function}
\usage{
segment2(object, ...)

\S4method{segment2}{TrioSet}(object, md = NULL, segmentParents = TRUE, verbose = TRUE, ...)

\S4method{segment2}{matrix}(object, pos, chrom, id, featureNames, ...)

\S4method{segment2}{ff_matrix}(object, pos, chrom, id, featureNames, ...)

\S4method{segment2}{arrayORff_array}(
  object,
  pos,
  chrom,
  id,
  featureNames,
  segmentParents = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{see \code{showMethods{segment2}}}

\item{...}{Additional arguments passed to DNAcopy's \code{segment}.}

\item{md}{a matrix of the minimum distance}

\item{segmentParents}{logical.  Whether to segment the log R ratios
of the parents using circular binary segmentation.}

\item{verbose}{logical. Whether to display messages that indicate progress.}

\item{pos}{integer vector of physical position of markers in the genome}

\item{chrom}{character or integer vector of chromosome names}

\item{id}{character vector of trio identifiers for subsetting \code{object}}

\item{featureNames}{character vector specifying marker names for subsetting \code{object}}
}
\description{
Methods for circular binary segmentation.
}
\seealso{
\code{\link{segment}}

\code{\link[DNAcopy]{segment}}
}
