% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMA.R
\name{DMA}
\alias{DMA}
\title{DMA}
\usage{
DMA(
  dataMAF,
  dataDEGs,
  dataPRA,
  runCscape = TRUE,
  coding_file,
  noncoding_file,
  results_folder = "./DMAresults"
)
}
\arguments{
\item{dataMAF}{A MAF file rda object.
The MAF file must at least contain the following columns:
\itemize{
\item Hugo_Symbol eg. BRCA1
\item Chromosome eg. chr1
\item Start_Position eg. 54402
\item End_Position e.g. 54443
\item Strand eg. +
\item Variant_Classification
\item Variant_Type
\item Reference_Allele
\item Tumor_Seq_Allele1
\item Tumor_Seq_Allele2
}}

\item{dataDEGs}{Output DEA function.}

\item{dataPRA}{Output PRA function.}

\item{runCscape}{Bolean. If \code{FALSE} will load CScape output file from results-folder
Default = \code{TRUE}.}

\item{coding_file}{A character string. Path to and name of CScape-somatic coding file.
Can be downloaded at \url{http://cscape-somatic.biocompute.org.uk/#download}. The .tbi file must be placed in the same folder.}

\item{noncoding_file}{A charcter string. Path to and name of CScape-somatic noncoding file.
Can be downloaded at \url{http://cscape-somatic.biocompute.org.uk/#download}. The .tbi file must be placed in the same folder.}

\item{results_folder}{A character string. Path to the results generated by this function.}
}
\value{
List of two, containing TSGs and OCGs with at least one driver mutation. Additionally files are saved in \code{results_folder}.
All output files are in compressed .rda format.
\describe{
\item{DEG_mutations_annotations.rda}{All differentially expressed genes’ mutations and their annotations. These annotations include e.g. Cscape-somatic assessment, Level of Consequence, overlab with promoter sites and information from Network of Cancer Genes (NCG 7.0). All information from MAF and DEA is contained.}
\item{Oncogenic_mediators_annotation_summary.rda}{All oncogenic mediators and an summarisation of their mutation based on CScape-somatic assessment, Level of Consequences and total number of mutations. If a gene as previously been assessed as a driver in Network of Cancer Genes (7.0), it is annotated in a separate column. }
\item{Cscape_somatic_output.rda}{The file contain the cscape-somatic assessment for every mutation found in the differentially expressed genes. It is formatted exactly as the output of cscape-somatic, as if it was run in the terminal, except it is saved as .rda instead of csv. }
}
}
\description{
This function carries out the driver mutation analysis.
}
\details{
For more information about the different annotations added to the mutations please see the documentation as followes:
\code{data(NCG)}, \code{data(EncodePromoters)}, \code{data(LOC_protein)}
\code{data(LOC_transcription)} and \code{data(LOC_translation)}.
}
\examples{
\donttest{
DMA(dataMAF = dataMAF,
    dataDEGs = DEGsmatrix,
    dataPRA = dataPRA,
    coding_file = "path/css_coding.vcf.gz",
    noncoding_file = "path/css_noncoding.vcf.gz",
    results_folder = "path/results")

#If the cscape-somatic file have already been created
cscape_somatic_output <- read.csv("./results/Cscape_somatic_output.csv")
save(cscape_somatic_output, file = "./results/Cscape_somatic_output.rda")

DMA(dataMAF = dataMAF,
    dataDEGs = DEGsmatrix,
    dataPRA = dataPRA,
    runCscape = FALSE,
    results_folder = "./results")
}
}
