% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{compareBedFiless2UserProvidedRegions}
\alias{compareBedFiless2UserProvidedRegions}
\title{Compare a set of bed files to a user provided regions set}
\usage{
compareBedFiless2UserProvidedRegions(bedfiles, motifnames, givenRegion)
}
\arguments{
\item{bedfiles}{a vector of bed files}

\item{motifnames}{a vector of the names related to bed files}

\item{givenRegion}{granges of user provided binding regions}
}
\value{
A dataframe which includes precision recall values for each bed file
}
\description{
This function gets user provided bedfiles and compare them with
 a user provided region.

It returns this comparison to given user binding regions in
 terms of precision/recall.
}
\examples{

yeastExampleFile=system.file("extdata", "YeastSampleMotif.bed",
                              package="Motif2Site")
YeastRegionsChIPseq <- Bed2Granges(yeastExampleFile)
bed1 <- system.file("extdata", "YeastBedFile1.bed", package="Motif2Site")
bed2 <- system.file("extdata", "YeastBedFile2.bed", package="Motif2Site")
BedFilesVector <- c(bed1, bed2)
SequenceComparison <- compareBedFiless2UserProvidedRegions(
     givenRegion=YeastRegionsChIPseq,
     bedfiles=BedFilesVector,
     motifnames=c("YeastBed1", "YeastBed2")
     )
SequenceComparison

}
\seealso{
\code{\link{compareMotifs2UserProvidedRegions}}
}
